<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
* @filesource
*//** */


/**
* Extended to display backtraces for the db queries.
* Requires use of an extension of system/database/DB_driver.php to cache backtraces for the db queries.
*
* @package direct-as-a-service
* @subpackage libraries
*/
class DPII_Profiler extends CI_Profiler {
	
	/**
	 * Compile Queries
	 *
	 * @access	private
	 * @return	string
	 */	
	function _compile_queries()
	{
		$dbs = array();

		// Let's determine which databases are currently connected to
		foreach (get_object_vars($this->CI) as $CI_object)
		{
			if (is_object($CI_object) && is_subclass_of(get_class($CI_object), 'CI_DB') )
			{
				$dbs[] = $CI_object;
			}
		}
					
		if (count($dbs) == 0)
		{
			$output  = "\n\n";
			$output .= '<fieldset style="border:1px solid #0000FF;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
			$output .= "\n";
			$output .= '<legend style="color:#0000FF;">&nbsp;&nbsp;'.$this->CI->lang->line('profiler_queries').'&nbsp;&nbsp;</legend>';
			$output .= "\n";		
			$output .= "\n\n<table cellpadding='4' cellspacing='1' border='0' width='100%'>\n";
			$output .="<tr><td width='100%' style='color:#0000FF;font-weight:normal;background-color:#eee;'>".$this->CI->lang->line('profiler_no_db')."</td></tr>\n";
			$output .= "</table>\n";
			$output .= "</fieldset>";
			
			return $output;
		}
		
		// Load the text helper so we can highlight the SQL
		$this->CI->load->helper('text');

		// Key words we want bolded
		$highlight = array('SELECT', 'DISTINCT', 'FROM', 'WHERE', 'AND', 'LEFT&nbsp;JOIN', 'ORDER&nbsp;BY', 'GROUP&nbsp;BY', 'LIMIT', 'INSERT', 'INTO', 'VALUES', 'UPDATE', 'OR', 'HAVING', 'OFFSET', 'NOT&nbsp;IN', 'IN', 'LIKE', 'NOT&nbsp;LIKE', 'COUNT', 'MAX', 'MIN', 'ON', 'AS', 'AVG', 'SUM', '(', ')');

		$output  = "\n\n";
			
		foreach ($dbs as $db)
		{			
			$output .= '<fieldset style="border:1px solid #0000FF;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
			$output .= "\n";
			$output .= '<legend style="color:#0000FF;">&nbsp;&nbsp;'.$this->CI->lang->line('profiler_database').':&nbsp; '.$db->database.'&nbsp;&nbsp;&nbsp;'.$this->CI->lang->line('profiler_queries').': '.count($db->queries).'&nbsp;&nbsp;&nbsp;</legend>';
			$output .= "\n";		
			$output .= "\n\n<table cellpadding='4' cellspacing='1' border='0' width='100%'>\n";
		
			if (count($db->queries) == 0)
			{
				$output .= "<tr><td width='100%' style='color:#0000FF;font-weight:normal;background-color:#eee;'>".$this->CI->lang->line('profiler_no_queries')."</td></tr>\n";
			}
			else
			{	
				$output .= '<script type="text/javascript">
<!--
    function profiler_toggle(tr_id, toggle_id) {
       var tr = document.getElementById(tr_id);
	   var toggle = document.getElementById(toggle_id);			 

       if(tr.style.display == \'table-row\'){
          tr.style.display = \'none\';
					toggle.innerHTML = \'&darr;\';
			 }
       else{
          tr.style.display = \'table-row\';
					toggle.innerHTML = \'&uarr;\';
			 }
    }
//-->
</script>
';
		
				foreach ($db->queries as $key => $val)
				{					
					$time = number_format($db->query_times[$key], 4);
					$val = highlight_code($val, ENT_QUOTES);
						
					foreach ($highlight as $bold)
					{
						$val = str_replace($bold, '<strong>'.$bold.'</strong>', $val);	
					}
					
					$td_style = 'color:#990000;font-weight:normal;background-color:#ddd;';					
					$output .= "<tr><td width='1%' valign='top' style='".$td_style."'>".$time."&nbsp;&nbsp;</td>";
					$output .= "<td style='color:#000;font-weight:normal;background-color:#ddd;'>".$val."</td>";				
					if(!empty($db->queries_backtrace[$key]['file']) && !empty($db->queries_backtrace[$key]['short_file']) && !empty($db->queries_backtrace[$key]['line'])){
						$output .= "<td style='".$td_style."'>".$db->queries_backtrace[$key]['function']."()</td>";
						$onclick = 'onclick="profiler_toggle(\''.$db->database.'_query_backtrace_'.$key.'\', \'query_toggle_'.$key.'\')"';
						$output .= "<td style='".$td_style."'><a title=\"".$db->queries_backtrace[$key]['file']."\" ".$onclick.">".$db->queries_backtrace[$key]['short_file']." :".$db->queries_backtrace[$key]['line']."</a></td>";
						$output .= '<td id="query_toggle_'.$key.'" style="'.$td_style.'" '.$onclick.'>&darr;</td>';
					}
					$output .= "</tr>\n";
					
					if(property_exists($db, 'queries_backtrace') && !empty($db->queries_backtrace)){
						$backtrace = $db->queries_backtrace[$key]['backtrace'];
						
						ob_start();
						echo '<tr id="'.$db->database.'_query_backtrace_'.$key.'" style="display:none;" ><td></td><td colspan="4"><table cellpadding="4" cellspacing="1" border="0" width="100%">';
						require APPPATH.'errors/_backtrace.php';
						echo '</table></td></tr>';
						$output .= ob_get_clean();
					}
				}
			}
			
			$output .= "</table>\n";
			$output .= "</fieldset>";
			
		}
		
		return $output;
	}

}

// END CI_Profiler class

/* End of file Profiler.php */
/* Location: ./system/libraries/Profiler.php */